"""
HB_Clone V1.1

Last Modified: Oct/02/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Clone
Description-US: Clones the current selected Polygons on place [SHIFT: Clone all connected Polygons] 
Clones the current selected Polygons on place and enables Move-Tool

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=15m11s
https://youtu.be/UlY-X5O137M?t=377
ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/02/2018 V1.1
- Python Rewrite
- Optimizations
- Shift modifier to clone connected Polygons

"""
import c4d
from c4d import gui,utils

def main():



    bc = c4d.BaseContainer()
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc)
    Shift=False   
    if bc[c4d.BFM_INPUT_QUALIFIER] ==1 : Shift=True   # SHIFT Click
         
   

    doc.StartUndo()
    selobj=doc.GetActiveObject()
    if not selobj:
        return
    
    mode=doc.GetMode()
    if doc.GetMode()==7: # is Polymode active? Run selction Command
        c4d.utils.SendModelingCommand(command = c4d.MCOMMAND_SELECTPOLYTOPOINT,
                                    list = [selobj],
                                    mode = c4d.MODELINGCOMMANDMODE_POLYGONSELECTION,
                                    bc = c4d.BaseContainer(),
                                    doc = doc)
    else:
        return
    
    
    #CLONE POLYS
    if Shift: c4d.CallCommand(12557) # Select Connected
    
    doc.AddUndo(c4d.UNDOTYPE_CHANGE,selobj)
    CloneCommand = c4d.ID_MODELING_CLONE_TOOL
    mode = c4d.MODELINGCOMMANDMODE_POLYGONSELECTION
    options = c4d.BaseContainer()

    options[c4d.MDATA_CLONE_OFFSET] = 0
    options[c4d.MDATA_CLONE_AXIS]=0
    options[c4d.MDATA_CLONE_CNT]=1
    options[c4d.MDATA_CLONE_SCALE]=1
    options[c4d.MDATA_CLONE_LOCALSCALE]= c4d.Vector(1,1,1)
    utils.SendModelingCommand(command=CloneCommand, list=[selobj], mode=mode, bc=options, doc=doc)
    
    
    #MOVETOOL
    
    c4d.CallCommand(200000088)#MOVE
    if not (c4d.IsCommandChecked(1016176)):
        
        c4d.CallCommand(1016176)#Show AXIS
        
    
   
    doc.EndUndo()


if __name__=='__main__':
    main()
    c4d.EventAdd() 
